CREATE FUNCTION CF_Valor_Descrip (
	@Id_Valor				INT,
	@Id_Moneda				CHAR(3),
	@Id_Tipo_Val			CHAR(3),
	@Descripcion			VARCHAR(100),
	@Valor_Nro				INT,
	@Id_Banco				SMALLINT,
	@Fecha_Acreditacion		DATETIME,
	@Cuit					VARCHAR(13),
	@Id_Tarjeta				VARCHAR(10),
	@Tarjeta_Lote			SMALLINT,
	@Tarjeta_Nro			VARCHAR(25),
	@Tarjeta_Vence			DATETIME,
	@Tarjeta_Cant_Cuotas	TINYINT,
	@Id_Cta_Banco			SMALLINT
	)
RETURNS VARCHAR(500)
AS
BEGIN

IF (ISNULL(@Id_Valor,0) != 0)
	SELECT 	@Id_Moneda = Id_Moneda,	
			@Id_Tipo_Val = Id_Tipo_Val,
			@Descripcion = Descripcion,			
			@Valor_Nro = Valor_Nro,
			@Id_Banco = Id_Banco,
			@Fecha_Acreditacion	= Fecha_Acreditacion,
			@Cuit = Cuit,
			@Id_Tarjeta	= Id_Tarjeta,
			@Tarjeta_Lote = Tarjeta_Lote,
			@Tarjeta_Nro = Tarjeta_Nro,
			@Tarjeta_Vence = Tarjeta_Vence,
			@Tarjeta_Cant_Cuotas = Tarjeta_Cant_Cuotas,
			@Id_Cta_Banco = Id_Cta_Banco
			FROM Valores WHERE Id_Valor = @Id_Valor



DECLARE @Retorno VARCHAR(100)
DECLARE @Descripcion_Bco VARCHAR(50)
DECLARE @Descripcion_Tar VARCHAR(50)
DECLARE @Descripcion_BcoCta VARCHAR(100)
DECLARE @Cuenta_Nro VARCHAR(50)
DECLARE @Signo CHAR(3)

SET @Descripcion_Tar = ISNULL((SELECT Descripcion FROM Valores_Tarjetas_Cred WHERE Id_Tarjeta = @Id_Tarjeta),'')
SET @Signo = ISNULL((SELECT Signo FROM Valores_Monedas WHERE Id_Moneda = @Id_Moneda),'')
SET @Descripcion_Bco = ISNULL((SELECT Descripcion FROM Bancos WHERE Id_Banco = @Id_Banco),'')
SET @Descripcion_Tar = ISNULL((SELECT Descripcion FROM Valores_Tarjetas_Cred WHERE Id_Tarjeta = @Id_Tarjeta),'')
SET @Descripcion_BcoCta = ISNULL((SELECT Descripcion FROM Bancos_Ctas WHERE Id_Cta_Banco = @Id_Cta_Banco),'')
SET @Cuenta_Nro = ISNULL((SELECT Cuenta_Nro FROM Bancos_Ctas WHERE Id_Cta_Banco = @Id_Cta_Banco),'')
	


SET @Retorno = ISNULL( LTRIM( RTRIM( (SELECT Descripcion FROM Valores_Tipos WHERE Id_Tipo_Val = @Id_Tipo_Val) )),'*')


/*e_Efectivo*/
IF @Id_Tipo_Val = 'EFE'
	SET @Retorno = LTRIM( RTRIM( @Descripcion ) )

/*e_Dif_Cam*/
IF @Id_Tipo_Val = 'DIC'
	SET @Retorno = LTRIM( RTRIM( @Retorno ))

/*e_Fac_Cre*/
IF @Id_Tipo_Val = 'FAC'
	SET @Retorno = LTRIM( RTRIM( @Retorno )) 
			+ ' Nro.:'
			+ CAST(@Valor_Nro AS VARCHAR(20)) 
			+' ' + LTRIM( RTRIM( @Descripcion ) )

/*e_Ajuste*/
IF @Id_Tipo_Val = 'AJU'
	SET @Retorno = LTRIM( RTRIM( @Descripcion ) )

/*e_Tickets*/
IF @Id_Tipo_Val = 'TIC'
	SET @Retorno = LTRIM( RTRIM( @Retorno ))+ ' ' + LTRIM( RTRIM( @Descripcion ) )

/*e_Cheque3*/
IF @Id_Tipo_Val = 'CH3'
	SET @Retorno = LTRIM( RTRIM( @Retorno ))
					+ ' ' 
					+ LTRIM( RTRIM( @Signo ) )
					+ ' ' 
					+ ' Nro.:'
					+ CAST(@Valor_Nro AS VARCHAR(20)) 
					+ ' ' 
					+ CONVERT(VARCHAR(10),@Fecha_Acreditacion,3)   --dd-mm-aa
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion_Bco ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Cuit ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )

/*e_Tarjeta*/
IF @Id_Tipo_Val = 'TAR'
BEGIN
	SET @Retorno = LTRIM( RTRIM( @Descripcion_Tar ))
					+ ' ' 
					+ LTRIM( RTRIM( RIGHT(@Tarjeta_Nro,4) ) )	
	IF  LTRIM( RTRIM( @Tarjeta_Lote ) )	!= ''
		SET @Retorno = LTRIM( RTRIM( @Retorno ))
					+ ' ' 
					+ LTRIM( RTRIM( @Tarjeta_Lote ) )	

	IF (@Tarjeta_Vence IS NOT NULL)
		SET @Retorno = LTRIM( RTRIM( @Retorno ))+ ' ' 
					+ ' ' 
					+ CONVERT(VARCHAR(10),@Tarjeta_Vence,3)   --dd-mm-aa

	SET @Retorno = LTRIM( RTRIM( @Retorno )) 
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )
END

/*e_Finan*/
IF @Id_Tipo_Val = 'FIN'
BEGIN
	SET @Retorno = LTRIM( RTRIM( @Descripcion_Tar ))
					+ ' Cant.Cuotas:' 
					+ CAST( @Tarjeta_Cant_Cuotas AS VARCHAR(10))

	IF (@Tarjeta_Vence IS NOT NULL)
		SET @Retorno = LTRIM( RTRIM( @Retorno ))+ ' ' 
					+ '   1er Vto: ' 
					+ CONVERT(VARCHAR(10),@Tarjeta_Vence,3)   --dd-mm-aa

	SET @Retorno = LTRIM( RTRIM( @Retorno )) 
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )
	
	SET @Retorno = LTRIM( RTRIM( @Retorno ))+ ' ' + LTRIM( RTRIM( @Descripcion ) )
END

/*e_Cupon*/
IF @Id_Tipo_Val = 'CUP'
BEGIN
	SET @Retorno = LTRIM( RTRIM( @Descripcion_Tar ))
					+ ' ' 
					+ LTRIM( RTRIM(@Tarjeta_Nro ) )	

	IF  LTRIM( RTRIM( @Tarjeta_Lote ) )	!= ''
		SET @Retorno = LTRIM( RTRIM( @Retorno ))
					+ ' Lote: ' 
					+ LTRIM( RTRIM( @Tarjeta_Lote ) )	

	IF (@Tarjeta_Vence IS NOT NULL)
		SET @Retorno = LTRIM( RTRIM( @Retorno ))+ ' ' 
					+ ' ' 
					+ CONVERT(VARCHAR(10),@Tarjeta_Vence,3)   --dd-mm-aa

	SET @Retorno = LTRIM( RTRIM( @Retorno )) 
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )
END

/*e_ChequeProp*/
IF @Id_Tipo_Val = 'CHP'
	SET @Retorno = LTRIM( RTRIM( @Signo ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Retorno ))
					+ ' ' 
					+ ' Nro.:'
					+ CAST(@Valor_Nro AS VARCHAR(20)) 
					+ ' ' 
					+ CONVERT(VARCHAR(10),@Fecha_Acreditacion,3)   --dd-mm-aa
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion_Bco ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )

/*e_Depositos*/
IF @Id_Tipo_Val = 'DB'
	SET @Retorno = LTRIM( RTRIM( @Signo ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Retorno ))
					+ ' ' 
					+ ' Cuenta:'
					+ CAST(@Cuenta_Nro AS VARCHAR(20)) 
					+ ' Fecha: ' 
					+ CONVERT(VARCHAR(10),@Fecha_Acreditacion,3)   --dd-mm-aa
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion_Bco ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )


/*e_Cta_Personal*/
IF @Id_Tipo_Val = 'CTA'
	SET @Retorno = LTRIM( RTRIM( @Signo ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Retorno ))
					+ ' ' 
					+ ' Cuenta:'
					+ CAST(@Cuenta_Nro AS VARCHAR(20)) 
					+ ' Fecha' 
					+ CONVERT(VARCHAR(10),@Fecha_Acreditacion,3)   --dd-mm-aa
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion_Bco ) )
					+ ' ' 
					+ LTRIM( RTRIM( @Descripcion ) )


RETURN RTRIM(LTRIM(SUBSTRING(@Retorno,1,100)))
END

